package ch.frankel.blog.hibernate.model;

import static javax.persistence.GenerationType.IDENTITY;

import java.util.Date;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.GeneratedValue;
import javax.persistence.Id;
import javax.persistence.ManyToOne;
import javax.persistence.Table;

import org.apache.commons.lang.builder.ToStringBuilder;

/**
 * An order.
 * 
 * @author Nicolas Frnkel
 * @since 20 juin 2009
 */
@Entity
@Table(name = "ORDERS")
public class Order extends AbstractEntity {

    @Id
    @GeneratedValue(strategy = IDENTITY)
    private long id;

    @ManyToOne
    private Customer customer;

    @Column(name = "ORDER_DATE")
    private Date orderDate;

    public Customer getCustomer() {

        return customer;
    }

    public long getId() {

        return id;
    }

    public Date getOrderDate() {

        return orderDate;
    }

    /**
     * Sets this order's customer. Does not manage bidirectional associations.
     * 
     * @param aCustomer
     */
    public void setCustomer(Customer aCustomer) {

        customer = aCustomer;
    }

    public void setId(long aId) {

        id = aId;
    }

    public void setOrderDate(Date aOrderDate) {

        orderDate = aOrderDate;
    }

    /**
     * @see java.lang.Object#toString()
     */
    @Override
    public String toString() {

        return new ToStringBuilder(this, TO_STRING_STYLE).append("id", id).append("orderDate", orderDate).append(
                "customer", getCustomer() == null ? null : getCustomer().getId()).toString();
    }

    /**
     * @see java.lang.Object#equals(java.lang.Object)
     */
    @Override
    public boolean equals(Object aObj) {

        if (id == 0) {

            return false;
        }

        if (!(aObj instanceof Order)) {

            return false;
        }

        Order aOrder = (Order) aObj;

        return id == aOrder.id;
    }

    /**
     * @see java.lang.Object#hashCode()
     */
    @Override
    public int hashCode() {

        return Long.valueOf(id).hashCode();
    }
}
